/*
Windows Live Mail quotefix
AutoHotkey script (http://www.autohotkey.com/)
source: http://www.dusko-lolic.from.hr/
last update: 2011-01-28 (YYYY-MM-DD)
modified: 2011-02-12 http://www.manfredhund.de/
*/

;hotkey is Win+9 (upper row 9, not numeric pad 9)
#9::
;give up if active window is not WLM - delete the following two lines to make quotefix work with any program
IfWinNotActive, ahk_class ATH_Note 
return

IniRead, signature, WLMQuoteFix.ini, Sig, 1 
if signature <>
signature=%signature% `r

IniRead, signature2, WLMQuoteFix.ini, Sig, 2
if signature2 <>
signature=%signature% %signature2% `r

IniRead, signature3, WLMQuoteFix.ini, Sig, 3
if signature3 <>
signature=%signature% %signature3% `r

IniRead, signature4, WLMQuoteFix.ini, Sig, 4
if signature4 <>
signature=%signature% %signature4% `r

IniRead, signature5, WLMQuoteFix.ini, Sig, 5
if signature5 <>
signature=%signature% %signature5% `r

IniRead, signature6, WLMQuoteFix.ini, Sig, 6
if signature6 <>
signature=%signature% %signature6% `r

AutoTrim, off

SigLines=2 ;number of lines in signature (cursor positioning)

IniRead, qchar, WLMQuoteFix.ini, Quote_Chr, Q 

Stringreplace, qchar, qchar, space, %A_SPACE%


;qchar=> ;quote character
garbage1=__________ ESET
garbage2=__________ Information from ESET

;string literal (dash dash space) cannot end with space, has to be built
sigdashes=-- -
stringleft,sigdashes,sigdashes,3



send,{Space} ;in case of a new (empty) message, give the script something to copy to clipboard
send,^a ;select all text (CTRL+A)
sleep,200 ;give WLM time to react - improves script reliability
send,^c ;copy to clipboard (CTRL+C)
sleep,200

out=
Loop, parse, clipboard , `n, `r
{
    ifequal A_LoopField,%sigdashes% ;stop quoting if signature delimiter is found
      break
    if A_INDEX>2 ;the first two lines of quoted message are empty, skip them and start processing from the third line
    {
    if InStr(A_LoopField,garbage1) or InStr(A_LoopField,garbage2) ;cut off garbage from the end of quote
      break
    if A_INDEX>3 ;insert quote character from line four onwards, the 3rd line is "xyz wrote..." and doesn't need quote char
      out=%out%%qchar%
    out=%out%%A_LoopField%`r
    }
} 

out=%out%`r ;insert an empty line (make space for reply)
out=%out%%sigdashes%`r ;signature delimiter
out=%out%%signature% ;signature

clipboard=%out% ;push to clipboard
send,^a ;select all, yes, again. Should not be necessary but improves cooperation with WLM
sleep,100
send,^v ;paste into WLM (CTRL+V)
sleep,200
loop,% SigLines+1 ;set the cursor just above the signature
  send,{Up}

return

;debug - reload edited script with Win+8
/*
#8::
reload
return
*/
